/**
 * 
 */
package gov.va.med.mhv.phr.wellnessreminders.model;

import org.displaytag.decorator.TableDecorator;

/**
 * Defines the order in which Wellness reminder view summaries are ordered.
 * @author                   
 */
public class WellnessReminderRowSorter extends MultiPropertyRowSorter{

    private static final SortOrder[] SORT_ORDER = {
        new SortOrder("dueDate", false),
        new SortOrder("subject", true),
        new SortOrder("dateLastDone", true),
        new SortOrder("location", true)
    };

    public WellnessReminderRowSorter(String propertyName, TableDecorator tableDecorator,
        boolean isAscending)
    {
        super(propertyName, tableDecorator, isAscending);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.phr.wellnessreminders.model.MultiplePropertySorter#getSortOrder()
     */
    @Override
    protected SortOrder[] getSortOrder()
    {
        return SORT_ORDER;
    }

}
